//	CDialog3Button.c
#include "ADFS_LogFile.h"
#include "ADFS_Menus.h"
#include "ADFS_Commands.h"
#include "ADFS_Prefs.h"

#include "CDialog3Button.h"

/********************************************************/

DGI_ItemRec		g3Button_ItemTable[kDlog_3Button_ItemStr_NUMTYPES] = {
	{	kDlog_3Button_ItemID_BUTTON_1,	"",		teJustCenter,	normal	},
	{	kDlog_3Button_ItemID_BUTTON_2,	"",		teJustCenter,	normal	},
	{	kDlog_3Button_ItemID_BUTTON_3,	"",		teJustCenter,	normal	},
	{	kDlog_3Button_ItemID_VERB,		"",		teJustLeft,		normal	}
};

/********************************************************/
CDialog3Button	*gCDialog3Button = NULL;

CDialog3Button	*Show3ButtonDialog(
		Dlog3ButtonParamRec *dlogParamsP)
{
	if (!gCDialog3Button) {
		gCDialog3Button = new CDialog3Button;
		
		if (gCDialog3Button) {
			if (!gCDialog3Button->IDialog3Button(dlogParamsP)) {
				gCDialog3Button->Dispose();
				gCDialog3Button = NULL;
			}
		}
	}

	return gCDialog3Button;
}

/********************************************************/

void		CDialog3Button::CopyButtonStr(Dlog_ItemIDType itemID)
{
	Dlog3ButtonRec		*buttonP = GetButtonP(itemID);
	char				*itemStrP = i_itemStrTable[
			GetItemTableIndex(i_itemStrTable, itemID, kDlog_3Button_ItemStr_NUMTYPES)].itemStr;

	if (buttonP->keyEquivChar) {
		sprintf(itemStrP, "%s [%c]", buttonP->nameAC, buttonP->keyEquivChar);
	} else {
		strcpy(itemStrP, buttonP->nameAC);
	}
}

#define		HideIfHidden(_itemID)	\
	if (!GetButtonP(_itemID)->visibleB) HideDlogItem(_itemID);

Boolean		CDialog3Button::IDialog3Button(
	Dlog3ButtonParamRec *dlogParamsP)
{
	Boolean		success = TRUE;
	
	//	get it hidden, then show
	success = _inherited::IDialog(ADFS_Window_MODAL_DIALOG, kDlog_ID_3Button);
	
	if (success) {		
		short	actionItem;
		
		GetSysFontRec(&i_fontRec);

		i_paramRec	= *dlogParamsP;

		memcpy(
			i_itemStrTable, g3Button_ItemTable, 
			sizeof(DGI_ItemRec) * kDlog_3Button_ItemStr_NUMTYPES);

		strcpy(
			i_itemStrTable[kDlog_3Button_ItemStr_VERB].itemStr,
			i_paramRec.verbageAC);

		CopyButtonStr(kDlog_3Button_ItemID_BUTTON_1);
		CopyButtonStr(kDlog_3Button_ItemID_BUTTON_2);
		CopyButtonStr(kDlog_3Button_ItemID_BUTTON_3);

		ValueConvert(DGI_ValueConvert_TO, kDlog_3Button_ItemID_BUTTON_1);
		ValueConvert(DGI_ValueConvert_TO, kDlog_3Button_ItemID_BUTTON_2);
		ValueConvert(DGI_ValueConvert_TO, kDlog_3Button_ItemID_BUTTON_3);
		ValueConvert(DGI_ValueConvert_TO, kDlog_3Button_ItemID_VERB);
		
		SetDlgItemUseStdDraw(kDlog_3Button_ItemID_VERB);

		actionItem = GetActionButton(Dlog_Action_DEFAULT);
		if (actionItem) {
			SetDialogDefaultItem(GetDialogRef(), actionItem);
		}

		actionItem = GetActionButton(Dlog_Action_CANCEL);
		if (actionItem) {
			SetDialogCancelItem(GetDialogRef(), actionItem);
		}
		
		HideIfHidden(kDlog_3Button_ItemID_BUTTON_1);
		HideIfHidden(kDlog_3Button_ItemID_BUTTON_2);
		HideIfHidden(kDlog_3Button_ItemID_BUTTON_3);
	}

	if (success) {
		Rect		windR	= (**gPrefsH).windA[PREF_Wind_3BUTTON];
		
		if (!EmptyRect(&windR)) {
			MoveWindow(
				GetWindowRef(), 
				windR.left, 
				windR.top, 
				FALSE);
		}
		
		SetTitle(i_paramRec.titleAC);
		
		ShowWindow(GetWindowRef());
	}
	
	if (success) {
		SetModalUp(TRUE);
	}

	return success;
}

void		CDialog3Button::Dispose(void)
{
	gCDialog3Button = NULL;

	_inherited::Dispose();

	SetModalUp(FALSE);
}

void		CDialog3Button::Finish(short itemHitS)
{
	HideWindow(GetWindowRef());
	
	if ((*i_paramRec.DoneCB)(GetButtonP(itemHitS)->buttonID, i_paramRec.cbData)) {
		Dispose();
	} else {
		ShowWindow(GetWindowRef());
	}
}

Dlog3ButtonRec		*CDialog3Button::GetButtonP(Dlog_ItemIDType itemID)
{
	Dlog3ButtonRec		*buttonP = NULL;
	
	switch (itemID) {
		case kDlog_3Button_ItemID_BUTTON_1:
		case kDlog_3Button_ItemID_BUTTON_2:
		case kDlog_3Button_ItemID_BUTTON_3: {
			buttonP = &i_paramRec.buttonA[itemID - kDlog_3Button_ItemID_BUTTON_1];
			break;
		}
	}
	
	ASSERT(buttonP);
	
	return buttonP;
}

Dlog_ItemIDType		CDialog3Button::GetKeyCharButton(char theKey)
{
	Dlog_ItemIDType		itemS;
	Dlog3ButtonRec		*buttonP;
	
	for (
		itemS = kDlog_3Button_ItemID_BUTTON_1;
		itemS <= kDlog_3Button_ItemID_BUTTON_3;
		itemS++
	) {
		buttonP = GetButtonP(itemS);
		
		if (buttonP->keyEquivChar == theKey) {
			break;
		}
	}
	
	if (itemS > kDlog_3Button_ItemID_BUTTON_3) {
		itemS = kDlog_3Button_ItemID_NONE;
	}

	return itemS;
}

Dlog_ItemIDType		CDialog3Button::GetActionButton(Dlog_ActionType actionSeek)
{
	Dlog_ItemIDType		itemS;
	Dlog3ButtonRec		*buttonP;
	Boolean				seek_def_cancelB = 
		actionSeek == Dlog_Action_DEFAULT
		|| actionSeek == Dlog_Action_CANCEL;
	
	for (
		itemS = kDlog_3Button_ItemID_BUTTON_1;
		itemS <= kDlog_3Button_ItemID_BUTTON_3;
		itemS++
	) {
		buttonP = GetButtonP(itemS);

		if (
			buttonP->actionType == actionSeek
			|| (
				seek_def_cancelB
				&& buttonP->actionType == Dlog_Action_DEFAULT_CANCEL
			)
		) {
			break;
		}
	}
	
	#ifdef DEBUG
		Dlog_ItemIDType		theRest;

		for (
			theRest = itemS + 1;
			theRest <= kDlog_3Button_ItemID_BUTTON_3;
			theRest++
		) {
			ASSERT(GetButtonP(theRest)->actionType != actionSeek);
		}
	#endif
	
	if (itemS > kDlog_3Button_ItemID_BUTTON_3) {
		itemS = kDlog_3Button_ItemID_NONE;
	}
		
	return itemS;
}


void	CDialog3Button::DoKeyDown(EventRecord *event)
{
	Dlog_ActionType	keyResult	= Dlog_Action_NONE;
	char			theKey		= VirtualASCII(event);

	if (event->modifiers & cmdKey) {
		
		//	cut, copy, paste, clear all get handled at the top
			
		switch (theKey) {
			
			case '.': {
				keyResult = Dlog_Action_CANCEL;
				break;
			}
		}
	} else {

		switch (theKey) {
			
			case RETURN_KEY:
			case ENTER_KEY: {
				keyResult = Dlog_Action_DEFAULT;
				break;
			}
			
			case ESC_CLEAR_KEY: {
				keyResult = Dlog_Action_CANCEL;
				break;
			}
		}		
	}
	
	switch (keyResult) {
		
		default: {
			Dlog_ItemIDType		buttonID = GetKeyCharButton(theKey);
			
			if (buttonID != kDlog_3Button_ItemID_NONE) {
				SimulateClick(buttonID);
				Finish(buttonID);
			} else {
				_inherited::DoKeyDown(event);
			}
			break;
		}

		case Dlog_Action_DEFAULT:
		case Dlog_Action_CANCEL: {
			Dlog_ItemIDType		buttonID = GetActionButton(keyResult);
			
			if (buttonID != kDlog_3Button_ItemID_NONE) {
				SimulateClick(buttonID);
				Finish(buttonID);
			}
			break;
		}
	}
}

void	CDialog3Button::DoClick(EventRecord *event)
{
	if (FrontWindow() != GetWindowRef()) {
		_inherited::DoClick(event);
	} else {
		DialogRef		theDialog;
		short			itemHit;
		
		DialogSelect(event, &theDialog, &itemHit);

		switch (itemHit) {
		
			case kDlog_3Button_ItemID_BUTTON_1:
			case kDlog_3Button_ItemID_BUTTON_2:
			case kDlog_3Button_ItemID_BUTTON_3: {
				Finish(itemHit);
				break;
			}
		}
	}
}

void	CDialog3Button::Move(EventRecord *event)
{
	_inherited::Move(event);
	(**gPrefsH).windA[PREF_Wind_3BUTTON] = GetWindowRect(WindowRect_ALL_GLOBAL);
	SavePrefs();
}

void	CDialog3Button::DialogItemStandardDrawProc(
	DialogItemIndex	itemNo, 
	Rect			*itemRectP)
{
	char				str1[256];
//	unsigned char		*str1P		= (unsigned char *)str1;
	Boolean				drawStringB	= FALSE;
	short				justifyS	= teJustLeft;
	
	Prepare();

	switch (itemNo) {
		
		case kDlog_3Button_ItemID_VERB: {
			short	tableIndex = GetItemTableIndex(
				i_itemStrTable, itemNo, kDlog_3Button_ItemStr_NUMTYPES);
			
			strcpy(str1, i_itemStrTable[tableIndex].itemStr);
			justifyS = i_itemStrTable[tableIndex].justifyS;
			TextFace(i_itemStrTable[tableIndex].face);
			drawStringB	= TRUE;
			break;
		}
	}

	if (drawStringB) {
		DrawCStringInRect(str1, itemRectP, justifyS);
	}
}

void		CDialog3Button::ValueConvert(
	DGI_ValueConvertType	convertType, 
	short					dlgItem)
{
////	ControlRef			controlRef = GetDlogItemControl(dlgItem);
//	Boolean				convertFromB = FALSE;
	
	switch (dlgItem) {
		
		case kDlog_3Button_ItemID_BUTTON_1:
		case kDlog_3Button_ItemID_BUTTON_2:
		case kDlog_3Button_ItemID_BUTTON_3:
		case kDlog_3Button_ItemID_VERB: {
			if (convertType == DGI_ValueConvert_TO) {
				short			tableIndex	= GetItemTableIndex(
					i_itemStrTable, dlgItem, kDlog_3Button_ItemStr_NUMTYPES);

				SetDlogItemText(dlgItem, i_itemStrTable[tableIndex].itemStr);
				
				switch (dlgItem) {
					
					case kDlog_3Button_ItemID_BUTTON_1:
					case kDlog_3Button_ItemID_BUTTON_2: {
						Rect	bestR	= GetBestRect(dlgItem);
						Rect	origR;	GetDlogItemRect(dlgItem, &origR);
						
						if (dlgItem == kDlog_3Button_ItemID_BUTTON_1) {
							origR.right = origR.left + (bestR.right - bestR.left);
						} else {
							origR.left = origR.right - (bestR.right - bestR.left);
						}

						SetDlogItemRect(dlgItem, &origR);
						break;
					}
				}

			}
			break;
		}
	}
}

void		CDialog3Button::UpdateMenus(void)
{
	_inherited::UpdateMenus();
}

Boolean		CDialog3Button::DoCommand(long command)
{
	Boolean			handled = FALSE;
	
	switch (command) {
		
		default: {
			handled = _inherited::DoCommand(command);
			break;
		}
	}
	
	return handled;
}
